% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program TvCcostfunc.m
function L = TvCcostfunc(guess, data)

beta = guess(1);
gamma = guess(2);
Nm = guess(3);
Sa = guess(4);
NperformanceLevels = size(data, 1) -1;
NnoiseLevels = size(data, 2) - 1;
Next = data(1, 2:(NnoiseLevels+1));
dprime = norminv(data(2:(NperformanceLevels+1), 1)) - ...
      norminv( 1- data(2:(NperformanceLevels+1), 1));

L=0;
for i = 1:NperformanceLevels
    Log_observedThresholds = ...
      log(data(i+1, 2:(NnoiseLevels+1)));
    d = dprime(i);
    Log_predictedThresholds = 1 / (2*gamma) * (2*log(d') ...
      + log((1+Nm^2) * Next.^(2*gamma) + Sa^2) - ...
      log(1-Nm.^2*d.^2/2)) - log(beta);
    L = L+sum((Log_observedThresholds -...
      Log_predictedThresholds).^2);
end
